function f_out=decode_filt(f_in,Fs)
%
% This function simply does a band-pass filter to rewrite
% the data as a 500 - 3200 Hz signal for the decoded signal with Fa=3500 Hz
% Note - I couldn't get a satisfactory response using firpm
% to design a band-pass filter directly!
%

%% Filtering
%Fs=11025*2;
% High-pass filter: 300 Hz cut-off
hhp=firpm(200,[0 250*2/Fs 500*2/Fs  1],[0 0 1 1 ],[1 10 ]);
% Low-pass filter: cutt-off 3000 Hz
hlp=firpm(200,[0 3200*2/Fs 3700*2/Fs  1],[1 1 0 0 ],[10 1 ]);

f_out= fftfilt(hlp,fftfilt(hhp,f_in));

%% See the filter 
% figure
% freqz(hhp,1,100,Fs),hold on,freqz(hlp,1,100,Fs)
% legend('High Pass','Low Pass')
% title('Post-Encoding (Pre-Decoding) Filter')
% hold on
% set(gcf,'color','w')
% legend('Low Pass: Fs=11.025 KHz','High Pass: Fs=11.025 KHz','Low Pass: Fs=22.05 KHz','High Pass: Fs=22.05 KHz')
